/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.console;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.PanelHelper;
import com.izforge.izpack.util.Console;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class AbstractTextConsolePanel
extends AbstractConsolePanel {
    private static final Logger logger = Logger.getLogger(AbstractTextConsolePanel.class.getName());

    public AbstractTextConsolePanel(PanelView<ConsolePanel> panel) {
        super(panel);
    }

    @Override
    public boolean run(InstallData installData, Properties properties) {
        return true;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        String panelLabel = this.getPanelLabel(installData);
        if (panelLabel != null) {
            console.println(panelLabel);
        }
        String text = this.getText();
        if (this.substituteVariables()) {
            text = installData.getVariables().replace(text);
        }
        if (text != null) {
            Panel panel = this.getPanel();
            RulesEngine rules = installData.getRules();
            boolean paging = Boolean.parseBoolean(panel.getConfigurationOptionValue("console-text-paging", rules));
            boolean wordwrap = Boolean.parseBoolean(panel.getConfigurationOptionValue("console-text-wordwrap", rules));
            try {
                console.printMultiLine(text, wordwrap, paging);
            }
            catch (IOException e) {
                logger.warning("Displaying multiline text failed: " + e.getMessage());
            }
        } else {
            logger.warning("No text to display");
        }
        return this.promptEndPanel(installData, console);
    }

    protected String getPanelLabel(InstallData installData) {
        String titleMessageKey = PanelHelper.getPanelTitleMessageKey(this.getPanel(), "info", installData);
        return installData.getMessages().get(titleMessageKey, new Object[0]);
    }

    protected abstract String getText();

    protected boolean substituteVariables() {
        return true;
    }

    protected String removeHTML(String text) {
        String result = "";
        if (text != null) {
            result = text.replaceAll("\r", " ");
            result = result.replaceAll("\t", "");
            result = result.replaceAll("( )+", " ");
            result = this.removeHTMLTag(result, "base");
            result = this.removeHTMLTag(result, "link");
            result = this.removeHTMLTag(result, "meta");
            result = this.removeHTMLTag(result, "noscript");
            result = this.removeHTMLTag(result, "script");
            result = this.removeHTMLTag(result, "style");
            result = this.removeHTMLTag(result, "template");
            result = result.replaceAll("[ \\t]*<( )*title([^>])*>[ \\t]*", "<title>");
            result = result.replaceAll("([ \\t]*<( )*(/)( )*title( )*>[ \\t]*)", "</title>");
            result = this.removeHTMLTag(result, "sup");
            result = result.replaceAll("<( )*td([^>])*>", "\t");
            result = result.replaceAll("<( )*br( )*>", "\r");
            result = result.replaceAll("<( )*li( )*>", "\r");
            result = result.replaceAll("<( )*div([^>])*>", "\r\r");
            result = result.replaceAll("<( )*tr([^>])*>", "\r\r");
            result = result.replaceAll("(<) h (\\w+) >", "\r");
            result = result.replaceAll("(\\b) (</) h (\\w+) (>) (\\b)", "");
            result = result.replaceAll("<( )*p([^>])*>", "\r\r");
            result = result.replaceAll("<[^>]*>", "");
            result = result.replaceAll("&bull;", " * ");
            result = result.replaceAll("&lsaquo;", "<");
            result = result.replaceAll("&rsaquo;", ">");
            result = result.replaceAll("&trade;", "(tm)");
            result = result.replaceAll("&frasl;", "/");
            result = result.replaceAll("&lt;", "<");
            result = result.replaceAll("&gt;", ">");
            result = result.replaceAll("&copy;", "(c)");
            result = result.replaceAll("&reg;", "(r)");
            result = result.replaceAll("&(.{2,6});", "");
            result = result.replaceAll("(\r)( )+(\r)", "\r\r");
            result = result.replaceAll("(\t)( )+(\t)", "\t\t");
            result = result.replaceAll("(\t)( )+(\r)", "\t\r");
            result = result.replaceAll("(\r)( )+(\t)", "\r\t");
            result = result.replaceAll("(\r)(\t)+(\\r)", "\r\r");
            result = result.replaceAll("(\r)(\t)+", "\r\t");
            result = result.replaceAll("\\r", "\n");
            result = result.replaceAll("[\\t ]+\\n", "\n");
            result = result.replaceAll("\\n\\n+\\n", "\n\n").trim();
        }
        return result;
    }

    private String removeHTMLTag(String text, String tag) {
        String result = text.replaceAll("[ \\t]*<( )*" + tag + "([^>])*>[ \\t]*", "<" + tag + ">");
        result = result.replaceAll("([ \\t]*<( )*(/)( )*" + tag + "( )*>[ \\t]*)", "</" + tag + ">");
        return result.replaceAll("(<" + tag + ">)(.|\n)*(</" + tag + ">)", "");
    }
}

